///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2005 Siebel Systems, Inc.  All rights reserved.
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Criteria Validation
//
// These methods can be used by query blocking functions to ease the work of
// validating criteria
///////////////////////////////////////////////////////////////////////////////

//-------------------
function CriteriaValidator(analysisXml)
{
	this.xmlElement = analysisXml;
	if ((this.xmlElement != null) && (this.xmlElement.nodeName == "saw:report"))
	   this.criteria = this.xmlElement.selectSingleNode('saw:criteria');
	else
	   this.criteria = null;
}

// Remove quotes from quoted text
CriteriaValidator.removeQuotes = function(sText)
{
   if ((sText != null) && (sText.length > 0))
	{
	   // Remove quotes from quoted text
	   var re = /"([^"]*)"/g;
	   return sText.replace(re, "$1");
	}
	else
	   return "";
}

//-------------------
// This function returns the name of the subjectArea referenced by the request.
// It will generally be used in a switch statement within the function before
// doing other validation.
CriteriaValidator.prototype.getSubjectArea = function()
{
   if (this.criteria != null)
      return CriteriaValidator.removeQuotes(XUIGetAttributeString(this.criteria, "subjectArea"));

   return "";
}

//-------------------
// This function returns true if the specified table has been added to the
// request by the user, false if not.
CriteriaValidator.prototype.tableExists = function(sTable)
{
   if (this.criteria != null)
   {
      var tColumns = this.criteria.selectNodes('.//saw:column');

      for (var i = 0; i != tColumns.length; ++i)
      {
         var sFormula = CriteriaValidator.removeQuotes(tColumns[i].getAttribute('formula'));
         if (sFormula.indexOf(sTable + ".") == 0)
            return true;
      }
   }

   return false;
}

//-------------------
// This function returns true if the specified column has been added to the
// request by the user, false if not.
CriteriaValidator.prototype.columnExists = function(sTable, sColumn)
{
   if (this.criteria != null)
   {
      if ((sColumn == null) || (sColumn == ""))
         return this.tableExists(sTable);

      var tColumns = this.criteria.selectNodes('.//saw:column');
      for (var i = 0; i != tColumns.length; ++i)
      {
         if (CriteriaValidator.removeQuotes(tColumns[i].getAttribute('formula')) == (sTable + "." + sColumn))
            return true;
      }
   }

   return false;
}

//-------------------
// This function checks to make sure that the dependentColumn exists if the
// checkColumn is present.  It returns true if either the checkColumn isn't
// present, or if the checkColumn and the dependent column are present.
// sCheckColumn and/or dependentColumn can be null, in which case just the
// tables will be checked.
CriteriaValidator.prototype.dependentColumnExists = function(sCheckTable, sCheckColumn, sDependentTable, sDependentColumn)
{
   if ((this.criteria != null) && (this.columnExists(sCheckTable, sCheckColumn)))
      return this.columnExists(sDependentTable, sDependentColumn);
   else
      return true;
}

//-------------------
// This function returns true if a filter exists on the specified column, false
// if not.
CriteriaValidator.prototype.filterTableExists = function(sFilterTable)
{
   if (this.criteria != null)
   {
	   var tFilter = this.criteria.selectSingleNode("saw:filter");
	   if (tFilter != null)
	   {
         var tExpressions = tFilter.selectNodes(".//sawx:expr/sawx:expr[@xsi:type='sawx:sqlExpression']");
         for (var i = 0; i != tExpressions.length; ++i)
         {
            var sFormula = CriteriaValidator.removeQuotes(XUIGetElementText(tExpressions[i]));
            if (sFormula.indexOf(sFilterTable + ".") == 0)
               return true;
         }
      }
   }

   return false;
}

//-------------------
// This function returns true if a filter exists on the specified column, false
// if not.
CriteriaValidator.prototype.filterExists = function(sFilterTable, sFilterColumn)
{
   if (this.criteria != null)
   {
      if ((sFilterColumn == null) || (sFilterColumn == ""))
         return this.filterTableExists(sFilterTable);

	   var tFilter = this.criteria.selectSingleNode("saw:filter");
	   if (tFilter != null)
	   {
         var tExpressions = tFilter.selectNodes(".//sawx:expr/sawx:expr[@xsi:type='sawx:sqlExpression']");
         for (var i = 0; i != tExpressions.length; ++i)
         {
            if (CriteriaValidator.removeQuotes(XUIGetElementText(tExpressions[i])) == (sFilterTable + "." + sFilterColumn))
               return true;
         }
      }
   }

   return false;
}

//-------------------
// This function checks to make sure that the dependentFilter exists if the
// checkColumn is present.  It returns true if either the checkColumn isn't
// present, or if the checkColumn and the dependent filter are present.
CriteriaValidator.prototype.dependentFilterExists = function(sCheckTable, sCheckColumn, sFilterTable, sFilterColumn)
{
   if ((this.criteria != null) && (this.columnExists(sCheckTable, sCheckColumn)))
      return this.filterExists(sFilterTable, sFilterColumn);
   else
      return true;
}

//-------------------
// This function returns the number of filter values specified for given
// logical column.  If the filter is not "equals" or "in", the number of values
// cannot be determined and 999 will be returned.  If the column is not used in
// a filter, 0 will be returned.
CriteriaValidator.prototype.filterCount = function(sFilterTable, sFilterColumn)
{
   if (this.criteria != null)
   {
	   var tFilter = this.criteria.selectSingleNode("saw:filter");
	   if (tFilter != null)
	   {
         var tExpressions = tFilter.selectNodes(".//sawx:expr/sawx:expr[@xsi:type='sawx:sqlExpression']");
         for (var i = 0; i != tExpressions.length; ++i)
         {
            if (CriteriaValidator.removeQuotes(XUIGetElementText(tExpressions[i])) == (sFilterTable + "." + sFilterColumn))
            {
               var sOp = XUIGetAttributeString(tExpressions[i].parentNode, "op");
               switch (XUIGetXsiType(tExpressions[i].parentNode))
               {
                  case "comparison":
                     if ((sOp == "equal") || (sOp == "notNull") || (sOp == "null"))
                        return 1;
                     else
                        return 999;
                     break;
                  case "list":
                     if (sOp == "in")
                        return tExpressions[i].parentNode.childNodes.length - 1;
                     else
                        return 999;
                     break;
                  case "special":
                     return -1;
                     break;
                  default:
                     return 999; // can't determine how many values
                     break;
               }
            }
         }
      }
   }

   return 0;
}

